rule Win32_Ransomware_Knot : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "KNOT"
        description         = "Yara rule that detects Knot ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Knot"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 8B 45 ?? 50
            FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 75 ?? 32 C0 E9 ?? ?? ?? ?? 6A ?? 8B 4D ?? 51
            FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 75 ?? 32 C0 E9 ?? ?? ?? ?? 6A ?? 6A ?? 6A ??
            6A ?? 6A ?? 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 75 ?? 32 C0 E9 ?? ??
            ?? ?? 6A ?? 6A ?? 6A ?? 6A ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 75
            ?? 32 C0 E9 ?? ?? ?? ?? 8D 4D ?? 51 6A ?? 6A ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52
            FF 15 ?? ?? ?? ?? 85 C0 75 ?? 32 C0 E9 ?? ?? ?? ?? 6A ?? 8B 45 ?? 50 8B 4D ?? 51 8B
            55 ?? 52 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 32 C0 E9 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ??
            ?? ?? 8D 85 ?? ?? ?? ?? 50 6A ?? 6A ?? 6A ?? 6A ?? 8B 4D ?? 51 FF 15 ?? ?? ?? ?? 85
            C0 75 ?? 32 C0 E9 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15
            ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 75 ?? 32 C0 E9 ?? ?? ?? ?? 8D 85
            ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 6A ?? 6A ?? 6A ?? 8B 55 ?? 52 FF 15
        }

        $encrypt_files_p2 = {
            85 C0 75 ?? 32 C0 E9 ?? ?? ?? ?? 8B 45 ?? 50 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 FF
            15 ?? ?? ?? ?? 83 C4 ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 8D 95
            ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? C7 85 ?? ??
            ?? ?? ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 6A
            ?? 8D 95 ?? ?? ?? ?? 52 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 8B
            95 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 8B 4D ?? 51 FF 15 ?? ?? ?? ?? 8B 55 ?? 52 6A
            ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 74
            ?? 8B 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 52 8B 45 ?? 50 8B 4D
            ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 8D 95 ?? ?? ?? ?? 52 8B 45 ?? 50 8B 8D ?? ?? ??
            ?? 51 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 8B 4D ?? 51 FF 15
            ?? ?? ?? ?? 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 8B 4D ?? 51
            FF 15 ?? ?? ?? ?? B0 ?? 8B E5 5D C3
        }

        $find_files_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85
            ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ??
            ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 0F B7 8D ?? ?? ?? ?? 83 F9 ?? 0F 84 ?? ??
            ?? ?? 8B 95 ?? ?? ?? ?? 83 E2 ?? 89 95 ?? ?? ?? ?? 74 ?? 8D 85 ?? ?? ?? ?? 50 FF 15
            ?? ?? ?? ?? 83 F8 ?? 75 ?? 8B 4D ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? FF 15
            ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ??
            8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95
            ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 E8 ?? ??
            ?? ?? 83 C4 ?? 8D 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ??
            ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? C7 85 ?? ?? ?? ??
            ?? ?? ?? ?? EB ?? 8B 8D ?? ?? ?? ?? 83 C1 ?? 89 8D ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ??
            73 ?? 8B 95 ?? ?? ?? ?? 8B 04 95 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ??
            83 C4 ?? 85 C0 74 ?? C6 85 ?? ?? ?? ?? ?? EB ?? 0F B6 95 ?? ?? ?? ?? 83 FA ?? 75
        }

        $find_files_p2 = {
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? EB ?? 8B 85 ?? ?? ?? ?? 83 C0 ?? 89 85 ?? ?? ?? ?? 83
            BD ?? ?? ?? ?? ?? 73 ?? 8B 8D ?? ?? ?? ?? 8B 14 8D ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ??
            50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? C6 85 ?? ?? ?? ?? ?? EB ?? 0F B6 8D ?? ?? ??
            ?? 83 F9 ?? 0F 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ??
            ?? ?? ?? 50 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 83 C4 ?? 68 ?? ??
            ?? ?? 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ??
            ?? ?? 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ??
            68 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8B 95 ??
            ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 E8 ?? ?? ??
            ?? 83 C4 ?? 68 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ??
            ?? 8B 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50
            E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ??
            8B 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ??
            51 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ??
            8B E5 5D C3
        }

        $remote_connection = {
            55 8B EC 81 EC ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 6A
            ?? FF 15 ?? ?? ?? ?? 89 45 ?? FF 15 ?? ?? ?? ?? 3D ?? ?? ?? ?? 75 ?? 6A ?? FF 15 ??
            ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 83 F8 ?? 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ??
            ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C8 83 F9 ?? 0F 85 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 E8
            ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? FF 15 ?? ??
            ?? ?? E8 ?? ?? ?? ?? 99 B9 ?? ?? ?? ?? F7 F9 81 C2 ?? ?? ?? ?? 52 8D 95 ?? ?? ?? ??
            52 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 8D 8D
            ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 68 ?? ??
            ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 E8 ??
            ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 75 ?? 8D 85 ?? ?? ?? ?? 50
            FF 15 ?? ?? ?? ?? 33 C0 E9 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 6A ??
            6A ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? FF 15 ?? ?? ??
            ?? E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? EB ?? 8B 95 ?? ??
            ?? ?? 83 C2 ?? 89 95 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 7F ?? 8D 85 ?? ?? ?? ?? 50 8B
            8D ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 8B
            85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 74 ?? 83 BD ?? ?? ?? ?? ?? 74
            ?? EB ?? 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 83 F8 ?? 75 ?? 8D 95 ?? ?? ?? ?? 52
            E8 ?? ?? ?? ?? 83 C4 ?? EB ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF
            15 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 68 ?? ?? ??
            ?? 6A ?? FF 15 ?? ?? ?? ?? 33 C0 8B E5 5D C2
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $remote_connection
        )
}